#include "CTerrainSplited.h"

#include <GL/gl.h>
#include <GL/glext.h>

#define FREQ    4
#define PERSIST 0.6
#define NBOCTAV 4
#define CL      2

#define inv127 0.007874015748031496062992125984252

//initialisation du gnrateur de nbres aleatoires
inline void randomize(){
  srand((time_t) time(NULL));                           
}
//gnrateur de nbres alatoires entre 0 et n-1
inline int random(int n){
  return rand()%n;
}  

CTerrainSplited::CTerrainSplited()
:bFabrique(false),bFabriqueOld(false),bCalculNrm(false)
{
    w=h=0;//peace of area
    
    sclX=sclY=sclZ=1.0;
    spdX=spdY=1.0;
    
    limitW=w*sclX;
    limitH=h*sclZ;
    
    //fabriqueOld=calculNrm=fabrique=0;
    
    nbMkTr=Fourn=Thrd=0;
    mkTr=NULL;
    
    nbTer=terSel=0;
    Ters=NULL;
    posix=0.0;
    
    r=f=NULL;
    norml=NULL;
    oldMNT=NULL;
    
    idTex=0xFFFFFFFF;
    
    mntClNrm=NULL;
}

CTerrainSplited::~CTerrainSplited(){clear();}

#define coefSmth 0.8
#define profSmth 6

char **colleMNT(unsigned int w,unsigned int h,char **newMnt,char **&oldMNT)
{
    if(oldMNT)
    {
        float *line1=new float[w];
        float *line2=new float[w];
        
        signed short shrt;
        unsigned char y;
        unsigned int x;
        float *ptrLine;
        char *ptrNew,*ptrOld;
        
        ptrNew=newMnt[0];
        ptrOld=oldMNT[h-2];
        
        for(x=0;x<w;x++)
        {
            *ptrNew=*ptrOld;
            ptrNew++;ptrOld++;
        }
        
        ptrNew=newMnt[1];
        ptrOld=oldMNT[h-2];
        ptrLine=line1;
        
        for(x=0;x<w;x++)
        {
            *ptrLine=(((signed short)(*ptrOld))-((signed short)(*ptrNew)))*coefSmth;
            *ptrNew=*ptrOld;
            ptrNew++;ptrOld++;ptrLine++;
        }
        
        for(y=2;y<(profSmth+2);y++)
        {
            ptrLine=line1;
            ptrNew=newMnt[y];
            for(x=0;x<w;x++)
            {
                shrt=((signed short)(*ptrNew))+((signed short)(*ptrLine));
                if(shrt<=-128)*ptrNew=-128;
                else if(shrt>=127)*ptrNew=127;
                else *ptrNew=shrt;
                (*ptrLine)*=coefSmth;
                ptrLine++;ptrNew++;
            }
            
            line2[1]=(line1[1]+line1[0])/2.0;
            line2[w-2]=(line1[w-2]+line1[w-1])/2.0;
            
            for(x=1;x<(w-1);x++)
            {
                line2[x]=(line1[x-1]+line1[x]+line1[x+1])/3.0;
            }
            
            ptrLine=line1;line1=line2;line2=ptrLine;
        }
        
        delete []line1;
        delete []line2;
    }
    
    oldMNT=newMnt;
    
    return newMnt;
}

char **aleatGen(unsigned int w,unsigned int h,float **r,float **f,unsigned int freq,float persist,unsigned int nbOctav,unsigned short int cL);

/*
#include <stdio.h>

void wrt(unsigned char c,FILE *f)
{
    if(c<10)fprintf(f,"00%d ",(int)c);
    else if(c<100)fprintf(f,"0%d ",(int)c);
    else fprintf(f,"%d ",(int)c);
}
*/

//Paramtrage du terrain
void CTerrainSplited::InitTerrain(Vecteur p,unsigned int w,unsigned int h,float sclX,float sclY,float sclZ,float spdX,float spdY,unsigned char nbMkTr,unsigned char nbTer)
{
    randomize();
    
    okThrd=true;
    bFabrique=false;
    bFabriqueOld=false;
    bCalculNrm=false;
    //fabriqueOld=calculNrm=fabrique=0;
    pthread_mutex_init(&mtxTabTr,NULL);
    pthread_mutex_init(&mtxNrm,NULL);
    this->p=p;
    
    h+=2;
    
    this->w=w;
    this->h=h;
    this->sclX=sclX;
    this->sclY=sclY;
    this->sclZ=sclZ;
    this->spdX=spdX;
    this->spdY=spdY;
    this->nbMkTr=nbMkTr;
    this->nbTer=nbTer;
    
    limitW=(w-1)*sclX;
    limitH=(h-1-2)*sclZ;
    
    randomize();
    
    unsigned int x,y;
    float ht;
    
    float **ptrRY;//,*ptrRX;
    r=ptrRY=new float *[h];
    for(y=0;y<h;y++)
    {
        *ptrRY=new float[w];//ptrRX=
        /*
        for(x=0;x<w;x++)
        {
            ht=-128+(rand()%256);
            *ptrRX=ht;
            ptrRX++;
        }
        */
        ptrRY++;
    }
    
    f=ptrRY=new float *[h];
    for(y=0;y<h;y++)
    {
        *ptrRY=new float[w];//ptrRX=
        //for(x=0;x<w;x++){*ptrRX=0.0;ptrRX++;}
        ptrRY++;
    }
    
    Vecteur **ptrNormlY;
    
    norml=ptrNormlY=new Vecteur*[h];
    for(y=0;y<h;y++)
    {
        *ptrNormlY=new Vecteur[w];
        ptrNormlY++;
    }
    
    mkTr=new STr[nbMkTr];
    for(y=0;y<nbMkTr;y++)mkTr[y].tr=NULL;
    
    Ters=new STrGID[nbTer];
    for(y=0;y<nbTer;y++)
    {
        Ters[y].tr.tr=colleMNT(w,h,aleatGen(w,h,r,f,FREQ,PERSIST,NBOCTAV,CL),oldMNT);
        mntClNrm=Ters[y].tr.tr;
        fMkNorm((void*)this);
        Ters[y].gID=mkGraphicArea(Ters[y].tr.tr);
    }
    
    /*
    FILE *f=fopen("tttt.txt","wt");
    
    for(y=0;y<h;y++)
    {
        for(x=0;x<w;x++)
        {
            wrt((*Ters).tr.tr[y][x],f);
        }
        fprintf(f,"\n");
    }
    
    fclose(f);
    */
    
    terSel=0;
    
    Thrd=Fourn=0;
    mntClNrm=NULL;
    pthread_create(&fabrique,NULL,fMkTerrain,(void*)this);
    bFabrique=true;
}

void CTerrainSplited::clear()
{
    okThrd=false;
    /*
    if(fabrique!=0)pthread_join(fabrique,NULL);
    if(fabriqueOld!=0)pthread_join(fabriqueOld,NULL);
    if(calculNrm!=0)pthread_join(calculNrm,NULL);
    */
    if(bFabrique){pthread_join(fabrique,NULL);bFabrique=false;}
    if(bFabriqueOld){pthread_join(fabriqueOld,NULL);bFabriqueOld=false;}
    if(bCalculNrm){pthread_join(calculNrm,NULL);bCalculNrm=false;}
    
    pthread_mutex_lock(&mtxTabTr);
    
    unsigned int i;
    
    if(mkTr)
    {
        for(i=0;i<nbMkTr;i++)mkTr[i].tr=clearMnt(h,mkTr[i].tr);
        delete []mkTr;
        mkTr=NULL;
        nbMkTr=0;
    }
    
    if(Ters)
    {
        for(i=0;i<nbTer;i++)
        {
            Ters[i].tr.tr=clearMnt(h,Ters[i].tr.tr);
            if(Ters[i].gID<0xFFFFFFFF)glDeleteLists(Ters[i].gID,1);
        }
        delete []Ters;
        Ters=NULL;
        nbTer=0;
    }
    
    if(r)
    {
        for(i=0;i<h;i++)
        {
            delete [](r[i]);
        }
        delete []r;
        r=NULL;
    }
 
    if(f)
    {
        for(i=0;i<h;i++)
        {
            delete [](f[i]);
        }
        delete []f;
        f=NULL;
    }
    
    pthread_mutex_unlock(&mtxTabTr);
    pthread_mutex_destroy(&mtxTabTr);
    
    pthread_mutex_lock(&mtxNrm);
    if(norml)
    {
        Vecteur **ptrNormlY;
        
        ptrNormlY=norml;
        for(i=0;i<h;i++)
        {
            delete [](*ptrNormlY);
            ptrNormlY++;
        }
        delete []norml;
        norml=NULL;
    }
    pthread_mutex_unlock(&mtxNrm);
    pthread_mutex_destroy(&mtxNrm);
    
    oldMNT=NULL;
    
    //fabriqueOld=calculNrm=fabrique=0;
    bFabrique=bFabriqueOld=bCalculNrm=false;
    Fourn=Thrd=0;
    terSel=0;
    posix=0.0;
}

void CTerrainSplited::putOtherArea()
{
    clearMnt(h,Ters[terSel].tr.tr);
    if(Ters[terSel].gID<0xFFFFFFFF)glDeleteLists(Ters[terSel].gID,1);
    
    Ters[terSel]=getTerrain();
    terSel=(terSel+1)%nbTer;
}

void CTerrainSplited::frameMove(float px)
{
    posix+=px;
    while(posix>limitH)
    {
        posix-=limitH;
        putOtherArea();
    }
}

//mettre la texture 3D du terrain
void CTerrainSplited::setTexture(unsigned int idTex)
{
    this->idTex=idTex;
}

void CTerrainSplited::CTerrainSplited::render()
{
    if(idTex<0xFFFFFFFF)
    {
        glBindTexture(GL_TEXTURE_3D, idTex);
        glEnable(GL_TEXTURE_3D);
    }
    glPushMatrix();
    glTranslatef(p.x,p.y,p.z-posix);
    unsigned char i;
    STrGID *ptr=Ters+terSel;
    for(i=terSel;i<nbTer;i++)
    {
        if(ptr->gID!=0xFFFFFFFF)
            glCallList(ptr->gID);
        glTranslatef(0.0,0.0,limitH);
        ptr++;
    }
    ptr=Ters;
    for(i=0;i<terSel;i++)
    {
        if(ptr->gID!=0xFFFFFFFF)
            glCallList(ptr->gID);
        glTranslatef(0.0,0.0,limitH);
        ptr++;
    }
    glPopMatrix();
    glDisable(GL_TEXTURE_3D);
}

float CTerrainSplited::getIDAreaPoint(float z)
{
    //p.x,p.y,p.z-posix
    return ((z-(p.z-posix))/limitH);
}

//hauteur du terrain en ces points
float CTerrainSplited::getHeight(float x,float z)
{
    x-=p.x;
    if(x<=0.0 || limitW<=x)return 0.0;
    
    float res=getIDAreaPoint(z);
    if(res<0.0 || ((unsigned int)res)>=nbTer)return 0.0;
    
    unsigned char nbTrToH=(unsigned char)res;
    unsigned char idTr=(nbTrToH+terSel)%nbTer;
    
    //(p.z-posix+limitH*idTr)
    
    //z-=p.z+limitH*idTr;
    //z+=posix;
    
    z-=(p.z-posix+limitH*nbTrToH);
    
    return getHeightMNT(x,z,Ters[idTr].tr.tr)+p.y;
}

//ne sert pas
float CTerrainSplited::getLimitTest(float x,float z)
{
    x-=p.x;
    if(x<=0.0 || limitW<=x)return 0.0;
    z-=(p.z-posix+limitH*((unsigned char)getIDAreaPoint(z)));
    
    return (z/sclZ);
}

//obtenir la pante
void CTerrainSplited::getNormal(Vecteur &v,float x,float z)
{
    v.x=0.0;
    v.y=1.0;
    v.z=0.0;
    
    x-=p.x;
    if(x<=0.0 || limitW<=x)return;
    
    float res=getIDAreaPoint(z);
    if(res<0.0 || ((unsigned int)res)>=nbTer)return;
    
    unsigned char nbTrToH=(unsigned char)res;
    unsigned char idTr=(nbTrToH+terSel)%nbTer;
    
    z-=(p.z-posix+limitH*nbTrToH);
    
    char **mnt=Ters[idTr].tr.tr;
    if(!mnt)return;
    
    x/=sclX;
    z/=sclZ;
    
    z+=1.0;
    
    if(((int)x)<0 || w<=((int)x) || ((int)z)<0 || h<=((int)z))return;
    
    Vecteur A;
    Vecteur B,C;
    
    A.x=(int)x;
    A.z=(int)z;
    
    bool inv;
    
    if((x-A.x)>=0.5)
    {
        A.x++;
        B.x=-1.0;
        B.z=0.0;
        inv=true;
    }
    else
    {
        B.x=1.0;
        B.z=0.0;
        inv=false;
    }
    
    if((z-A.z)>=0.5)
    {
        A.z++;
        C.x=0.0;
        C.z=-1.0;
        inv=!inv;
    }
    else
    {
        C.x=0.0;
        C.z=1.0;
    }
    
    //if(A.x<0 || (w-1)<=A.x || A.z<0 || (h-1)<=A.z)return 0.0;
    
    A.y=mnt[(int)A.z][(int)A.x]*0.007874015748031496062992125984252;
    B.y=mnt[(int)A.z][(int)B.x+(int)A.x]*0.007874015748031496062992125984252-A.y;
    C.y=mnt[(int)C.z+(int)A.z][(int)A.x]*0.007874015748031496062992125984252-A.y;
    
    v=C;
    v.cross(B);
    v.normalize();
    if(inv)v.inverse();
}

float CTerrainSplited::getHeightMNT(float x,float z,char **mnt)
{
  if(!mnt)return 0.0;
  
  x/=sclX;
  z/=sclZ;
  
  z+=1.0;
  
  if(((int)x)<0 || w<=((int)x) || ((int)z)<0 || h<=((int)z))return 0.0;
  
  Vecteur A;
  Vecteur B,C;
  
  A.x=(int)x;
  A.z=(int)z;
  
  bool inv;
  
  if((x-A.x)>=0.5)
  {
   A.x++;
   B.x=-1.0;
   B.z=0.0;
   inv=true;
  }
  else
  {
   B.x=1.0;
   B.z=0.0;
   inv=false;
  }
  
  if((z-A.z)>=0.5)
  {
   A.z++;
   C.x=0.0;
   C.z=-1.0;
   inv=!inv;
  }
  else
  {
   C.x=0.0;
   C.z=1.0;
  }
  
  //if(A.x<0 || (w-1)<=A.x || A.z<0 || (h-1)<=A.z)return 0.0;
  
  A.y=mnt[(int)A.z][(int)A.x]*0.007874015748031496062992125984252;
  B.y=mnt[(int)A.z][(int)B.x+(int)A.x]*0.007874015748031496062992125984252-A.y;
  C.y=mnt[(int)C.z+(int)A.z][(int)A.x]*0.007874015748031496062992125984252-A.y;
  
  //return A.y*height;
  
  Vecteur vUp(0.0,1.0,0.0),n;
  //n=absVect(normalize(produitvect(B,C)),vUp);
  n=C;
  n.cross(B);
  n.normalize();
  if(inv)n.inverse();
  
  A.x-=x;
  //A.y-=y;
  A.z-=z;
  
  x=vUp*n;
  if(x==0.0)return 0.0;
  return ((A*n)/x)*sclY;
}

float CTerrainSplited::getIntersec(Vecteur v,Vecteur d,float maxTime,float r,float precis)
{
    float ttc;
    
    ttc=v.x-p.x;
    ttc=v.z-p.z+posix;
    
    v.y-=p.y;
    ttc=v.y+d.y*maxTime;
    if((v.y>=sclY && ttc>=sclY)||(v.y<=-sclY && ttc<=-sclY) || (d.x==0.0 && d.y==0.0 && d.z==0.0))return maxTime;
    
    ttc=0.0;
    
    float t;
    
    if(v.y>sclY)
    {
        if(d.y>=-0.000000000001)return maxTime;
        ttc=-(v.y-sclY)/d.y;
    }
    else
    {
        if(v.y<-sclY)
        {
            if(d.y<=0.000000000001)return maxTime;
            ttc=-(v.y+sclY)/d.y;
        }
    }
    
    v.x-=p.x;
    if(v.x<0.0)
    {
        if(d.x<=0.000000000001)return maxTime;
        t=-v.x/d.x;
        if(t>ttc)
        {
            ttc=t;
            if(ttc>=maxTime)return maxTime;
        }
    }
    else
    {
        t=v.x-limitW;
        if(0.0<t)
        {
            if(d.x>=-0.000000000001)return maxTime;
            t=-t/d.x;
            if(t>ttc)
            {
                ttc=t;
                if(ttc>=maxTime)return maxTime;
            }
        }
    }
    
    v.z-=(p.z-posix);
    if(v.z<0.0)
    {
        if(d.z<=0.000000000001)return maxTime;
        t=-v.z/d.z;
        if(t>ttc)
        {
            ttc=t;
            if(ttc>=maxTime)return maxTime;
        }
    }
    else
    {
        t=v.z-limitH*nbTer;
        if(0.0<t)
        {
            if(d.z>=-0.000000000001)return maxTime;
            t=-t/d.z;
            if(t>ttc)
            {
                ttc=t;
                if(ttc>=maxTime)return maxTime;
            }
        }
    }
    
    float ttcInv=0.0;
    Vecteur pt(v);
    pt.x+=d.x*maxTime;
    pt.y+=d.y*maxTime;
    pt.z+=d.z*maxTime;
    
    d.inverse();
    
    if(pt.y>sclY)
    {
        if(d.y>=-0.000000000001)return maxTime;
        ttcInv=-(pt.y-sclY)/d.y;
    }
    else
    {
        if(pt.y<-sclY)
        {
            if(d.y<=0.000000000001)return maxTime;
            ttcInv=-(pt.y+sclY)/d.y;
        }
    }
    
    if(pt.x<0.0)
    {
        if(d.x<=0.000000000001)return maxTime;
        t=-pt.x/d.x;
        if(t>ttcInv)
        {
            ttcInv=t;
            if(ttc>=(maxTime-ttcInv))return maxTime;
        }
    }
    else
    {
        t=pt.x-limitW;
        if(0.0<t)
        {
            if(d.x>=-0.000000000001)return maxTime;
            t=-t/d.x;
            if(t>ttcInv)
            {
                ttcInv=t;
                if(ttc>=(maxTime-ttcInv))return maxTime;
            }
        }
    }
    
    if(pt.z<0.0)
    {
        if(d.z<=0.000000000001)return maxTime;
        t=-pt.z/d.z;
        if(t>ttcInv)
        {
            ttcInv=t;
            if(ttc>=(maxTime-ttcInv))return maxTime;
        }
    }
    else
    {
        t=pt.z-limitH*nbTer;
        if(0.0<t)
        {
            if(d.z>=-0.000000000001)return maxTime;
            t=-t/d.z;
            if(t>ttcInv)
            {
                ttcInv=t;
                if(ttc>=(maxTime-ttcInv))return maxTime;
            }
        }
    }
    
    d.inverse();
    
    float svMaxTime=maxTime-ttcInv;
    
    //idAbstract = numro du terrain dans le tableau Ters[]
    //idPhysic = numro depuis le premier terrain graphique
    unsigned char idAbstract,idPhysic;
    
    pt.x=v.x+d.x*ttc;
    pt.y=v.y+d.y*ttc;
    pt.z=v.z+d.z*ttc;
    
    idPhysic=(unsigned char)(pt.z/limitH);
    idAbstract=(idPhysic+terSel)%nbTer;
    
    pt.z-=idPhysic*limitH;
    
    float hypo=d.length();
    if(hypo<=0)return maxTime;
    r/=hypo;
    svMaxTime+=r;
    
    v.x=d.x/sclX;
    v.y=d.y/sclY;
    v.z=d.z/sclZ;
    
    hypo=v.length();
    v/=hypo;
    
    if(d.z==0.0)
    {
        t=tryInterserct(Ters[idAbstract].tr.tr,pt,v,hypo,svMaxTime,precis);
        if(t>=0.0 && t<svMaxTime)return (ttc+t-r);
    }
    else if(d.z>0.0)
    {
        do
        {
            ttcInv=-(pt.z-limitH)/d.z;
            if((ttc+ttcInv)>svMaxTime)ttcInv=svMaxTime-ttc;
            t=tryInterserct(Ters[idAbstract].tr.tr,pt,v,hypo,ttcInv,precis);
            if(t>=0.0)
            {
                if(t<ttcInv)return (ttc+t-r);
                else return maxTime;
            }
            ttc+=ttcInv;
            if(ttc<svMaxTime && idPhysic<nbTer)
            {
                pt.x+=d.x*ttcInv;
                pt.y+=d.y*ttcInv;
                pt.z+=d.z*ttcInv-limitH;
                idPhysic++;
                idAbstract=(idPhysic+terSel)%nbTer;
            }
            else break;
        }while(true);
    }
    else// if(d.z<0.0)
    {
        do
        {
            ttcInv=-(pt.z)/d.z;
            if((ttc+ttcInv)>svMaxTime)ttcInv=svMaxTime-ttc;
            t=tryInterserct(Ters[idAbstract].tr.tr,pt,v,hypo,ttcInv,precis);
            if(t>=0.0)
            {
                if(t<ttcInv)return (ttc+t-r);
                else return maxTime;
            }
            ttc+=ttcInv;
            if(ttc<svMaxTime && idPhysic>0)
            {
                pt.x+=d.x*ttcInv;
                pt.y+=d.y*ttcInv;
                pt.z+=d.z*ttcInv+limitH;
                idPhysic--;
                idAbstract=(idPhysic+terSel)%nbTer;
            }
            else break;
        }while(true);
    }
    
    return maxTime;
}

float CTerrainSplited::tryInterserct(char **mnt,Vecteur vA,Vecteur dir,float hypo,float maxT,float precis)
{
    vA.x/=sclX;vA.y/=sclY;vA.z/=sclZ;
    vA.z+=1.0;
    
    dir*=precis;
    hypo=precis/hypo;
    
    char tmp;
    
    vA.y*=127.0;
    dir.y*=127.0;
    
    unsigned int i,mx=1+(unsigned int)(maxT/hypo+0.5);
    
    for(i=0;i<mx;i++)
    {
        if(vA.x>=0.0 && vA.z>=0.0 && vA.x<w && vA.z<h)
        {
            tmp=mnt[(unsigned int)vA.z][(unsigned int)vA.x];
            //tmp*=0.007874015748031496062992125984252;
            if(tmp>=vA.y)//Intersection !!!
            {
                //return hypo*i;
                
                vA.y/=127.0;
                dir.y/=127.0;
                
                Vecteur A;
                Vecteur B,C;
                
                A.x=(int)vA.x;
                A.z=(int)vA.z;
                
                bool inv;
                
                if((vA.x-A.x)>=0.5)
                {
                    A.x++;
                    B.x=-1.0;
                    B.z=0.0;
                    inv=true;
                }
                else
                {
                    B.x=1.0;
                    B.z=0.0;
                    inv=false;
                }
                
                if((vA.z-A.z)>=0.5)
                {
                    A.z++;
                    C.x=0.0;
                    C.z=-1.0;
                    inv=!inv;
                }
                else
                {
                    C.x=0.0;
                    C.z=1.0;
                }
                
                //if(A.x<0 || (w-1)<=A.x || A.z<0 || (h-1)<=A.z)return 0.0;
                
                A.y=mnt[(int)A.z][(int)A.x]*0.007874015748031496062992125984252;
                B.y=mnt[(int)A.z][(int)B.x+(int)A.x]*0.007874015748031496062992125984252-A.y;
                C.y=mnt[(int)C.z+(int)A.z][(int)A.x]*0.007874015748031496062992125984252-A.y;
                
                //return A.y*height;
                
                Vecteur n(C);
                //n=absVect(normalize(produitvect(B,C)),vUp);
                //n=C;
                n.cross(B);
                n.normalize();
                if(inv)n.inverse();
                
                vA.x-=A.x;
                vA.y-=A.y;
                vA.z-=A.z;
                
                A.x=dir*n;
                if(A.x==0.0)return -1.0;
                return hypo*(i-((vA*n)/A.x));
            }
        }
        vA+=dir; 
    }
    
    return -1;
}

unsigned int CTerrainSplited::mkGraphicArea(char **mnt)
{
 if(w==0 || h==0 || mnt==0)return 0xFFFFFFFF;
 unsigned int lst;
 
 char **ptrMntY,*ptrMntX,*ptrMntXDn;
 Vecteur vTmp1,vTmp2;//,vTmp3,vTmp4,vTmp;
 float h1,h2;
 unsigned int /*dw,*/dh;
 dh=h-1;
 //dw=w-1;
 
 unsigned int x,y;
 //normal
 pthread_mutex_lock(&mtxNrm);
 if(!bCalculNrm)pthread_mutex_unlock(&mtxNrm);
 else
 {
        pthread_t cpy_calculNrm=calculNrm;
        pthread_mutex_unlock(&mtxNrm);
        pthread_join(cpy_calculNrm,NULL);
        bCalculNrm=false;
 }
 
 Vecteur **ptrNormlY,*ptrNormlX,*ptrNormlXDn;
 
 float tmpSclY=sclY*inv127;// /127.0
 
 /*
 float **lt,**ptrLtY,*ptrLtX,*ptrLtXDn;
 lt=ptrLtY=new float*[h];
 ptrNormlY=norml;
 ptrMntY=mnt;
 if(lightDir)
 {
  vTmp=lightPos;
  vTmp.normalize();
  
  for(y=0;y<h;y++)
  {
   *ptrLtY=ptrLtX=new float[w];
   ptrNormlX=*ptrNormlY;
   //ptrMntX=*ptrMntY;
   //vTmp1.x=0.0;
   for(x=0;x<w;x++)
   {
    ptrNormlX->normalize();
    
    //vTmp1.y=(*ptrMntX)*tmpSclY;
    
    *ptrLtX=-(vTmp*(*ptrNormlX));
    if(*ptrLtX<0.0)*ptrLtX=0.0;
    
    ptrNormlX++;
    ptrLtX++;
    //ptrMntX++;
    //vTmp1.x+=sclX;
   }
   ptrNormlY++;
   ptrLtY++;
   //ptrMntY++;
   //vTmp1.z+=sclZ;
  }
 }
 else
 {
  for(y=0;y<h;y++)
  {
   *ptrLtY=ptrLtX=new float[w];
   ptrNormlX=*ptrNormlY;
   ptrMntX=*ptrMntY;
   vTmp1.x=0.0;
   for(x=0;x<w;x++)
   {
    ptrNormlX->normalize();
    
    vTmp1.y=(*ptrMntX)*tmpSclY;
    vTmp=lightPos;
    vTmp-=vTmp1;
    vTmp.normalize();
    *ptrLtX=vTmp*(*ptrNormlX);
    if(*ptrLtX<0.0)*ptrLtX=0.0;
    
    ptrNormlX++;
    ptrLtX++;
    ptrMntX++;
    vTmp1.x+=sclX;
   }
   ptrNormlY++;
   ptrLtY++;
   ptrMntY++;
   vTmp1.z+=sclZ;
  }
 }
 */
 
 vTmp1.z=0.0;
 vTmp2.z=sclZ;
 
 lst=glGenLists(1);
 glNewList(lst,GL_COMPILE);
 //glNormal3f(0.0,0.0,0.0);
 
 float tex1X,tex1Y,tex2Y;//,spdX,spdY;
 tex1Y=0.0;
 
 //spdX=1.0/16.0;
 //spdY=1.0/16.0;
 
 tex2Y=spdY;
 
 ptrMntY=mnt+1;
 ptrNormlY=norml+1;
 //ptrLtY=lt;
 for(y=2;y<dh;y++)
 {
  ptrMntX=*ptrMntY;
  ptrMntXDn=*(ptrMntY+1);
  ptrNormlX=*ptrNormlY;
  ptrNormlXDn=*(ptrNormlY+1);
  //ptrLtX=*ptrLtY;
  //ptrLtXDn=*(ptrLtY+1);
  
  vTmp1.x=0.0;
  
  float multText=1.0;
  tex1X=0.0;
  
  glBegin(GL_QUAD_STRIP);
  for(x=0;x<w;x++)
  {
   vTmp1.y=(*ptrMntX)*tmpSclY;
   vTmp2.y=(*ptrMntXDn)*tmpSclY;
   
   //vTmp=lightColor;
   //vTmp*=(*ptrLtX);
   //vTmp+=AmbColor;
   //glColor3f(vTmp.x,vTmp.y,vTmp.z);
   //glTexCoord3f(multText*sclX*(x%2),0.0,0.5+(*ptrMntX)/256.0);//vTmp.y
   glTexCoord3f(tex1X,tex1Y,0.5+(*ptrMntX)/256.0);//vTmp.y
   glNormal3f(ptrNormlX->x,ptrNormlX->y,ptrNormlX->z);
   glVertex3f(vTmp1.x,vTmp1.y,vTmp1.z);
   
   //vTmp=lightColor;
   //vTmp*=(*ptrLtXDn);
   //vTmp+=AmbColor;
   //glColor3f(vTmp.x,vTmp.y,vTmp.z);
   //glTexCoord3f(multText*sclX*(x%2),multText*sclZ*1.0,0.5+(*ptrMntXDn)/256.0);//vTmp.y
   glTexCoord3f(tex1X,tex2Y,0.5+(*ptrMntX)/256.0);//vTmp.y
   glNormal3f(ptrNormlXDn->x,ptrNormlXDn->y,ptrNormlXDn->z);
   glVertex3f(vTmp1.x,vTmp2.y,vTmp2.z);
   
   ptrNormlX++;
   ptrNormlXDn++;
   ptrMntX++;
   ptrMntXDn++;
   //ptrLtX++;
   //ptrLtXDn++;
   
   vTmp1.x+=sclX;
   
   tex1X+=spdX;
  }
  glEnd();
  
  ptrNormlY++;
  ptrMntY++;
  //ptrLtY++;
  
  vTmp1.z+=sclZ;
  vTmp2.z+=sclZ;
  
  tex1Y+=spdY;
  tex2Y+=spdY;
 }
 
 /*
 glBegin(GL_LINES);
 
 vTmp1.z=0.0;
 ptrMntY=mnt;
 ptrNormlY=norml;
 for(y=0;y<h;y++)
 {
  ptrMntX=*ptrMntY;
  ptrNormlX=*ptrNormlY;
  vTmp1.x=0.0;
  for(x=0;x<w;x++)
  {
   glNormal3f(ptrNormlX->x,ptrNormlX->y,ptrNormlX->z);
   vTmp1.y=(*ptrMntX)*tmpSclY;
   glVertex3f(vTmp1.x,vTmp1.y,vTmp1.z);
   vTmp=vTmp1;
   vTmp+=*ptrNormlX;
   vTmp.y+=ptrNormlX->y*10;
   glVertex3f(vTmp.x,vTmp.y,vTmp.z);
   ptrMntX++;
   ptrNormlX++;
   vTmp1.x+=sclX;
  }
  ptrMntY++;
  ptrNormlY++;
  vTmp1.z+=sclZ;
 }
 
 glEnd();
 */
 
 glEndList();
 
 //for(y=0;y<h;y++)
 //{
 // delete [](lt[y]);
 //}
 //delete []lt;
 
 return lst;
}

CTerrainSplited::STrGID CTerrainSplited::getTerrain()
{
    char **mnt;
    pthread_mutex_lock(&mtxTabTr);
    
    mnt=mkTr[Fourn].tr;
    if(!mnt)
    {
        pthread_t cpy_fabrique;
        do
        {
            if(!bFabrique){pthread_create(&fabrique,NULL,fMkTerrain,(void*)this);bFabrique=true;}
            cpy_fabrique=fabrique;
            pthread_mutex_unlock(&mtxTabTr);
            pthread_join(cpy_fabrique,NULL);
            bCalculNrm=false;
            pthread_mutex_lock(&mtxTabTr);
        }while(!(mnt=mkTr[Fourn].tr));
    }
    
    mkTr[Fourn].tr=NULL;
    
    STrGID res;
    res.tr.tr=mnt;
    res.gID=mkGraphicArea(mnt);
    
    Fourn=(Fourn+1)%nbMkTr;
    mntClNrm=mkTr[Fourn].tr;
    
    pthread_mutex_lock(&mtxNrm);
    if(mntClNrm){pthread_create(&calculNrm,NULL,fMkNorm,(void*)this);bCalculNrm=true;}
    pthread_mutex_unlock(&mtxNrm);
    
    if(!bFabrique){pthread_create(&fabrique,NULL,fMkTerrain,(void*)this);bFabrique=true;}
    pthread_mutex_unlock(&mtxTabTr);
    
    return res;
}

float interpolate(float y1, float y2, int n, int delta)
{
	if (n==0)
	    return y1;
	if (n==1)
	    return y2;
	
	float a = (float)delta/n;
	
	float t1,t2;
	
	t1=1-a;
	t2=t1*t1;
	
	float v1 = 3*t2 - 2*(t1*t2);
	t1=a*a;
	float v2 = 3*t1 - 2*(a*t1);
	
	return y1*v1 + y2*v2;
}

float valeurInterpolate(unsigned int w,unsigned int h,unsigned int i,unsigned int j,unsigned int freq, float **r)
{
	/* dterminations des bornes */
	unsigned int borne1x, borne1y, borne2x, borne2y,q;
	float pasX,pasY;
	pasX = (float)w/freq;
	pasY = (float)h/freq;

	q = (unsigned int)((float)i/pasX);
	borne1x = (unsigned int)(q*pasX);
	borne2x = (unsigned int)((q+1)*pasX);

	if(borne2x >= w) 
		borne2x = w-1;

	q = (unsigned int)((float)j/pasY);
	borne1y = (unsigned int)(q*pasY);
	borne2y = (unsigned int)((q+1)*pasY);

	if(borne2y >= h) 
		borne2y = h-1;

	/* rcuprations des valeurs alatoires aux bornes */
	float b00,b01,b10,b11;
	b00 = r[borne1y][borne1x];
	b01 = r[borne2y][borne1x];
	b10 = r[borne1y][borne2x];
	b11 = r[borne2y][borne2x];

	float v1  = interpolate(b00, b01, borne2y-borne1y, j-borne1y);
	float v2  = interpolate(b10, b11, borne2y-borne1y, j-borne1y);
	float fin = interpolate(v1, v2, borne2x-borne1x , i-borne1x);

	return fin;
}

float vAbs(float a){return ((a>=0)?a:-a);}

//#define recop 0

int aleatBest;

char **aleatGen(unsigned int w,unsigned int h,float **r,float **f,unsigned int freq,float persist,unsigned int nbOctav,unsigned short int cL)
{
 //randomize();
 srand(aleatBest);
 aleatBest=rand();
 
 unsigned int x,y;
 float ht;
 
 float **ptrRY,*ptrRX;
 //r=ptrRY=new float *[h];
 
 unsigned int k,l,sx,sy,ex,ey;
 /*
 k=h-recop;
 for(y=0;y<recop;y++)
 {
    for(x=0;x<w;x++)r[y][x]=r[k][x];
    k++;
 }
 */
 //ptrRY=r+recop;
 //for(y=recop;y<h;y++)
 ptrRY=r;
 for(y=0;y<h;y++)
 {
  //*ptrRY=ptrRX=new float[w];
  ptrRX=*ptrRY;
  for(x=0;x<w;x++)
  {
    k=rand()%1000;
    //if(k<400)ht=-128;
    //else if(k<630)ht=-(64+rand()%65);
    //else if(k<720)ht=-(rand()%129);
    //else if(k<790)ht=255;
    //else if(k<830)ht=-128+rand()%256;
    //else ht=-64+rand()%128;
    if(k<300)ht=0.0;
    else if(k<400)ht=-64+rand()%128;
    else if(k<620)ht=-128;
    else if(k<690)ht=+127;
    else if(k<920)ht=-(64+rand()%65);
    else ht=(64+rand()%65);
    
   *ptrRX=ht;
   ptrRX++;
  }
  ptrRY++;
 }
 
 //f=ptrRY=new float *[h];
 ptrRY=f;
 for(y=0;y<h;y++)
 {
  //*ptrRY=ptrRX=new float[w];
  ptrRX=*ptrRY;
  for(x=0;x<w;x++){*ptrRX=0.0;ptrRX++;}
  ptrRY++;
 }
 
 ht=persist;
 unsigned int curFreq=freq;
 while(nbOctav)
 {
  nbOctav--;
  ptrRY=f;
  for(y=0;y<h;y++)
  {
   ptrRX=*ptrRY;
   for(x=0;x<w;x++)
   {
    (*ptrRX)+=valeurInterpolate(w,h,x,y,curFreq,r)*ht;
    ptrRX++;
   }
   ptrRY++;
  }
  curFreq*=freq;
  ht*=persist;
 }
 
 ht=0.00001;
 ptrRY=f;
 for(y=0;y<h;y++)
 {
  ptrRX=*ptrRY;
  for(x=0;x<w;x++)
  {
   if(vAbs(*ptrRX)>ht)ht=vAbs(*ptrRX);
   ptrRX++;
  }
  ptrRY++;
 }
 
  float tmp;
 /*
 persist=ht*2.0;
 //nbOctav
    
    x=0;nbOctav=w-1;
    while(x<10)
    {
        ptrRY=f;
        for(y=0;y<h;y++)
        {
            ptrRX=*ptrRY+x;
            tmp=*ptrRX+persist;
            if(tmp>ht)*ptrRX=ht;
            else *ptrRX=tmp;
            
            ptrRX=*ptrRY+nbOctav;
            tmp=*ptrRX+persist;
            if(tmp>ht)*ptrRX=ht;
            else *ptrRX=tmp;
            
            ptrRY++;
        }
        persist*=0.7;
        x++;nbOctav--;
    }
    */
 
 char **ptrMntY,*ptrMntX;
 
 unsigned short int n;
 
 char **mnt=ptrMntY=new char*[h];
 //ptrRY=f;
 for(y=0;y<h;y++)
 {
  *ptrMntY=ptrMntX=new char[w];
  //ptrRX=*ptrRY;
  for(x=0;x<w;x++)
  {
   n=0;
   tmp=0;
   
   if(x>cL)sx=x-cL;else sx=0;
   if(y>cL)sy=y-cL;else sy=0;
   
   ex=x+cL;
   if(ex>=w)ex=w-1;
   ey=y+cL;
   if(ey>=h)ey=h-1;
   
   ptrRY=f+sy;
   for(l=sy;l<=ey;l++)
   {
    ptrRX=(*ptrRY)+sx;
    for(k=sx;k<=ex;k++)
    {
     n++;
     tmp+=*ptrRX;
     ptrRX++;
    }
    ptrRY++;
   }
   if(n>0)tmp/=n;
   
   *ptrMntX=(char)((tmp/ht)*127.0);
   //ptrRX++;
   ptrMntX++;
  }
  //ptrRY++;
  ptrMntY++;
 }
 
 ptrMntY=mnt;
 for(y=0;y<h;y++)
 {
   (*ptrMntY)[0]=(*ptrMntY)[w-1]=-128;
   (*ptrMntY)[1]=(*ptrMntY)[w-2]=-64;
   ++ptrMntY;
 }
 
 return mnt;
}

#define myt ((CTerrainSplited*)data)

//usine terrain
void *fMkTerrain(void *data)
{
    pthread_mutex_lock(&(myt->mtxTabTr));
    while(myt->okThrd && !((myt->mkTr)[myt->Thrd].tr))
    {
        pthread_mutex_unlock(&(myt->mtxTabTr));
        if(myt->bFabriqueOld){pthread_join(myt->fabriqueOld,NULL);myt->bFabriqueOld=false;/*myt->fabriqueOld=0;*/}
    
        char **mnt=colleMNT(myt->w,myt->h,aleatGen(myt->w,myt->h,myt->r,myt->f,FREQ,PERSIST,NBOCTAV,CL),myt->oldMNT);
        
        pthread_mutex_lock(&(myt->mtxTabTr));
        
        (myt->mkTr)[myt->Thrd].tr=mnt;
        if(myt->Thrd==myt->Fourn)
        {
            pthread_mutex_lock(&(myt->mtxNrm));
            if(myt->bCalculNrm)
            {
                pthread_t cpy_calculNrm=myt->calculNrm;
                pthread_mutex_unlock(&(myt->mtxNrm));
                pthread_join(cpy_calculNrm,NULL);
                myt->bCalculNrm=false;
                pthread_mutex_lock(&(myt->mtxNrm));
            }
            myt->mntClNrm=mnt;
            pthread_create(&(myt->calculNrm),NULL,fMkNorm,data);
            myt->bCalculNrm=true;
            pthread_mutex_unlock(&(myt->mtxNrm));
        }
        
        myt->Thrd=(myt->Thrd+1)%(myt->nbMkTr);
    }
    myt->fabriqueOld=myt->fabrique;
    //myt->fabrique=0;
    myt->bFabrique=false;
    pthread_mutex_unlock(&(myt->mtxTabTr));
    
    return NULL;
}

//usine normals du terrain
void *fMkNorm(void *data)
{
    if(!(myt->okThrd))return NULL;
    
    char **mnt=myt->mntClNrm;
    if(!mnt)return NULL;
    
    unsigned int x,y;
    
    unsigned int dw,dh;
    dh=myt->h-1;
    dw=myt->w-1;
    
    Vecteur **norml=myt->norml,**ptrNormlY,*ptrNormlX;
    float sclX=myt->sclX,sclY=myt->sclY,sclZ=myt->sclZ,h1,h2;
     
     ptrNormlY=myt->norml;
        for(y=0;y<myt->h;y++)
        {
            ptrNormlX=*ptrNormlY;
            for(x=0;x<myt->w;x++)
            {
                ptrNormlX->x=0.0;
                ptrNormlX->y=0.0;
                ptrNormlX->z=0.0;
                ptrNormlX++;
            }
            ptrNormlY++;
        }
     
     Vecteur vTmp1,vTmp2,vTmp3,vTmp4,vTmp;
     
     //ptrMntY=mnt;
     //ptrNormlY=norml;
     for(y=0;y<dh;y++)
     {
      //ptrNormlX=*ptrNormlY;
      //ptrMntX=*ptrMntY;
      for(x=0;x<dw;x++)
      {
       
       vTmp1.x=sclX;
       vTmp1.z=0.0;
       vTmp2.x=0.0;
       vTmp2.z=sclZ;
       vTmp3.x=0.0;
       vTmp3.z=-sclZ;
       vTmp4.x=-sclX;
       vTmp4.z=0.0;
       
       vTmp2.y=vTmp1.y=(mnt[y][x])*inv127;// /127.0;
       vTmp4.y=vTmp3.y=(mnt[y+1][x+1])*inv127;// /127.0;
       
       h1=((mnt[y][x+1])*inv127);// /127.0
       h2=((mnt[y+1][x])*inv127);// /127.0
       
       vTmp1.y=h1-vTmp1.y;
       vTmp2.y=h2-vTmp2.y;
       
       vTmp3.y=h1-vTmp3.y;
       vTmp4.y=h2-vTmp4.y;
       
       vTmp1.y*=sclY;vTmp2.y*=sclY;
       vTmp3.y*=sclY;vTmp4.y*=sclY;
       
       vTmp=vTmp2;vTmp.cross(vTmp1);//vTmp.normalize();
       norml[y][x]+=vTmp;
       
       vTmp=vTmp3;vTmp.cross(vTmp4);//vTmp.normalize();
       norml[y+1][x+1]+=vTmp;
       
       vTmp1.inverse();
       vTmp2.inverse();
       vTmp3.inverse();
       vTmp4.inverse();
       
       vTmp=vTmp4;vTmp.cross(vTmp2);//vTmp.normalize();
       norml[y+1][x]+=vTmp;
       
       vTmp=vTmp1;vTmp.cross(vTmp3);//vTmp.normalize();
       norml[y][x+1]+=vTmp;
       
       //ptrNormlX++;
       //ptrMntX++;
      }
      //ptrNormlY++;
      //ptrMntY++;
     }
     
    ptrNormlY=myt->norml;
    for(y=0;y<myt->h;y++)
    {
        ptrNormlX=*ptrNormlY;
        for(x=0;x<myt->w;x++)
        {
            ptrNormlX->normalize();
            ptrNormlX++;
        }
        ptrNormlY++;
    }
    
    pthread_mutex_lock(&(myt->mtxNrm));
    myt->bCalculNrm=false;
    pthread_mutex_unlock(&(myt->mtxNrm));
    
    return NULL;
}

//fonction de destruction d'une matrice de terrain
char **clearMnt(unsigned int h,char **mnt)
{
    if(mnt)
    {
        unsigned int j;
        for(j=0;j<h;j++)delete [](mnt[j]);
        delete []mnt;
    }
    return NULL;
}
